#!/usr/local/bin/perl

sub get_database {
	my $line ;
	open (DATABASE, $database_file) or return 0;
	if ($line = <DATABASE>) {
		$line =~ s/database=//;
		$database = &trim($line);
		close DATABASE;
	}
	return 1;
		
}

sub ReadParse {
  
	my($i, $key, $val, $in, @in);
	if (&MethGet) {$in = $ENV{'QUERY_STRING'};} 
	if (&MethPost) {read(STDIN,$in,$ENV{'CONTENT_LENGTH'}); }
	if (length($in)>10000) {return 0;} #allow max 10K of input data
	
	@in = split(/[&;]/,$in); 
	foreach $i (0 .. $#in) {
		# Convert plus's to spaces
		$in[$i] =~ s/\+/ /g;
		# Split into key and value.  

		($key, $val) = split(/=/,$in[$i],2);
		# Convert %XX from hex numbers to alphanumeric
		$key =~ s/%(..)/pack("c",hex($1))/ge;
		$val =~ s/%(..)/pack("c",hex($1))/ge;

		# Associate key and value
		$val = &trim($val); 	#remove leading and trailing spaces
        $val =~ s/[<>]/ /g;		#convert dangerous characters (<,>) into spaces
		#print "key = $key<br>" if (defined($in{$key}));
		if (defined($in{$key})) {
			$in{$key} .= "|$val";
		} else {
			$in{$key} = $val;
		}
    }
	return 1;
}

# MethGet
# Return true if this cgi call was using the GET request, false otherwise
sub MethGet {return ($ENV{'REQUEST_METHOD'} eq "GET");}

# MethPost
# Return true if this cgi call was using the POST request, false otherwise
sub MethPost {return ($ENV{'REQUEST_METHOD'} eq "POST");}

sub nulls {
	return "Yes" unless $_[0];
	return "&nbsp;";
}


sub drop_table {
	
	my($drop_table) =@_;
	my($warned)     = '';
	
	$warned = $in{'warned'} if defined($in{'warned'}) ;
	$warned = "\L$warned\E";

	&print_error("Please select the table to delete.") unless $drop_table;
	&print_error("Cannot Drop Table $drop_table. It is included in the protected tables.") if ($excluded_tables =~ /,$drop_table,/);

	if ($warned eq "yes") {

		&drop_table_final($drop_table);
		if ($in{'action'} ne "change_name") {
			
			print &html ("Table Deleted!");
			print "Table <i>$drop_table</i> Deleted!";
			print &html_bot;
		
		}

	} else {
	
		print &html ("Drop Table!");
		print "<h2><blink>Warning</blink>: Table $drop_table will be Deleted!</h2><br>";
		print "
				$form_method
				<INPUT TYPE=\"HIDDEN\" NAME=\"table\" VALUE=\"$drop_table\">
				<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"drop_table\">
				Type \"YES\" in the box if you are sure:
				<INPUT TYPE=\"TEXT\" NAME=\"warned\" VALUE=\"\" MAXLENGTH=\"3\">
				<INPUT TYPE=\"SUBMIT\" NAME=\"Button\" VALUE=\"Drop Table\">
				</form>
			   ";
		print &html_bot;
	}
	
	return 1;

}

sub get_field_create_sql {
	
	my($field_name, $field_type, $field_lenght, $is_prim_key, $not_null)=@_;
	my($field_sql);

	$field_sql  = "";
	$field_sql .= "$field_name ";
	$field_sql .=  &sqltype($field_type);
	$field_sql .= "(".$field_lenght.") " if &sqltype($field_type) eq "CHAR";
	$field_sql .= " NOT NULL " if $not_null; 
	$field_sql .= " PRIMARY KEY " if $is_prim_key;
	return $field_sql;

}

sub primary {
	return "<b>*</b>" if $_[0];
	return "&nbsp;";
}

sub sqltype {
	return "CHAR" if $_[0]==2; 
	return "INT" if $_[0]==1; 
	return "REAL" if $_[0]==3; 
}

sub get_new_table_name {
	
	print &html("Choose New Table Name");
	print "
			$form_method
			Please Choose the New Table Name:
			<INPUT TYPE = \"TEXT\" NAME = \"new_table_name\" SIZE=\"30\" MAXLENGTH=\"30\">
			<INPUT TYPE = \"HIDDEN\" NAME = \"action\" VALUE=\"$in{'action'}\">
			<INPUT TYPE = \"HIDDEN\" NAME = \"table\" VALUE=\"$table\">
			<INPUT TYPE = \"SUBMIT\" NAME = \"submit\" value=\"Execute\">
			</form>
			<br>Click here for <a href = \"/msql_keeper/cgi/mk_main.cgi?action=naming_conventions\">miniSQL Field/Table Naming rules</a>.";
	print &html_bot;
	exit;
}

sub html {
	
	my($title) = @_;
	my($ret);
	$title = $action_verbose{$in{'action'}} unless $title;
	$title = "mSQL Keeper - $title";
		
	if (not $header_printed) {
		$ret  = "<html>\n<head>\n<title>$title</title>\n</head>\n<BODY 	TEXT=#000000 LINK=#330099 ALINK=#FF9900 VLINK=#CC3366 BGCOLOR=#FFFFFF>";
		$ret .= "<CENTER>\n<img src = \"/msql_keeper/img/msql_keeper.gif\" alt = \"mSQL Keeper\"><br>\n";
		$ret .= "<a href=\"http://hughes.com.au/\"><IMG SRC=\"/msql_keeper/img/msql.gif\" alt =\"miniSQL Home\" border=0></a>\n</CENTER><hr>";
		$ret .= "Database:&nbsp; <b>$database</b><br>\n";
		$ret .= "Table:&nbsp; <b>$table</b><br>\n";
		$ret .= "Action:&nbsp; <b>". $action_verbose{$in{'action'}}."</b><hr>\n"; 
		$header_printed = 1;
	} else {
		$ret = "<BR>";	
	}
	return $ret;
 }

sub html_bot {
	return "$anchors</body>\n</html>";
}

sub sql_fail {
	
	my $message  = "SELECT Command Failed:";
	   $message .= "<pre>$_[0]</pre>";
	   $message .= "&nbsp;Reason:&nbsp;<b>";
	   $message .= $Msql::db_errstr;
	   $message .= "</b>&nbsp;";
	   
	   &print_error($message);
}

sub print_error {

	my($message)=@_;
	print &html("Error");
	print "<b>Sorry, Can\'t Process this request.</b><br>";
	print "$message<br>";
	print &html_bot;
	exit;

}

sub field_exists {
	
	my($table_name, $fname)=@_;
	my($sth);
	
	return 0 if !&table_exists($table_name); #if table does not exist, don't bother checking if field exists

	$sth = $dbh->ListFields($table_name);
	for (0..$sth->numfields-1) {
		return 1 if $fname eq $sth->name->[$_];
	}
	return 0;
}

sub new_fields_boxes {
	my($j, $for_create)=@_;
	my($prim_key, $temp);

	for (1..$j){
		print "<tr><td> $_ </td><td> &nbsp;"; # I will not allow new fields to be the primary key.
		$temp = $new_name; $temp =~ s/#/$_/eg;
		print "$temp </td><td> &nbsp;";
		if ($for_create) {
			$temp = $new_primary_key; $temp =~ s/#/$_/eg;
			print "$temp </td><td> &nbsp;";
		}
		$temp = $new_type; $temp =~ s/#/$_/eg;
		print "$temp </td><td> &nbsp;";
		$temp = $new_null; $temp =~ s/#/$_/eg;
		print "$temp </td><td> &nbsp;";
		$temp = $new_len; $temp =~ s/#/$_/eg;
		print "$temp";
		print "</td></tr>\n";
	}
	return 1;
}

sub table_exists {
	
	#checks if a table exists in the current database
	my($table_name)=@_;
	my(@arr, $i);

	return 0 unless $table_name;
	
	@arr = $dbh->ListTables;
    foreach $i (0..$#arr){
		return 1 if $arr[$i] eq $table_name;
	}
	return 0;

}

sub remove_last_comma {
	#removes last comma from an SQL string;
	
	my($sql_string)=@_;
	$sql_string =~ s/^\s|\s+$//g;	#remove leading and trailing spaces
	
	#if rindex($sql_string,",")+1 == length($sql_string) then the last character of the string is a comma
	$sql_string = substr($sql_string, 0, length($sql_string)-1) if rindex($sql_string,",") + 1 == length($sql_string); #remove last comma
	
	return $sql_string;
}

sub SQLSelect {
	
	#constructs a Select Stmt for table $table_name
	
	my($table_name)=@_;
	my($sql) = &field_list($table_name);
	
	$sql = "SELECT $sql FROM $table_name";
	return $sql;

}

sub SQLCreate_new_fields {
	#constructs a Select Stmt from field definitions derived from the HTML form (info is kept on the $in array)
	
	my($field_count)=@_;
	my($sql, $i);

	foreach $i (0..$field_count) {
		if ($in{"new_name$i"}) {
			$sql .= &get_field_create_sql($in{"new_name$i"}, $in{"type$i"}, $in{"length$i"}, ($in{'prim_key'} eq "prim_key$i"), $in{"nulls$i"}).",";
		}
	}
	$sql = &remove_last_comma($sql);
	return $sql;
}

sub sql_insert_stmt {
	
	my($table_name)=@_;
	return "INSERT INTO $table_name (".&field_list($table_name).") VALUES (";

}
sub field_list {
	
	#returns field names for a table in a comma separated string (useful for Selects and Inserts)
	
	my($list_table) = @_;
	my($sql, $my_sth);

	$my_sth = $dbh->ListFields($list_table);
	for (0..$my_sth->numfields-1) {
		if ($in{"delete$_"}) {
			#the field was chosen to be deleted
			delete $in{"delete$_"};

		} else {
			$sql .= $my_sth->name->[$_].",";
			$field_type[$_] = $my_sth->type->[$_]; #global array with the type of the fields on the table we are curently working on
			$field_not_nulls[$i] = $my_sth->is_not_null->[$_];
			$field_length[$_] = $my_sth->length->[$_]; #global array with the type of the fields on the table we are curently working on
		}
	}

	$sql = &remove_last_comma($sql);
	return $sql;
}


sub new_fields_values {
	
	my($i, $value_list);
	
	foreach $i (0..$new_fields_count) {	#go thru new fields
		if ($in{"new_name$i"}) {
			
			if ($in{"nulls$i"} != 0) {
				# if $in{"nulls$i"} != means we do NOT allow nulls 
				$value_list .= "0," unless $in{"type$i"} == 2;	
				$value_list .= "\'\'," if $in{"type$i"} == 2;

			} else {
				$value_list .= "NULL,";
					
			}
		}
	}
    
	$value_list = &remove_last_comma($value_list);

}

sub check_table_name {
	#if $no_exit is true, then we just return 0
	#if $no_exit is false, then we print error and exit the program

	my($table_name, $no_exit) = @_;
	my(@arr, $i);
	my($err) = '';

	if ($table_name eq "") {
		$err = "You must enter the new table name.";
		&print_error($err) unless $no_exit;
		return $err;
	}

	if (!&valid_sql_name($table_name)) {
		$err = "<i><b>$table_name</i></b> is NOT a valid SQL Table\/Field Name.<br>$valid_names_text";
		&print_error($err) unless $no_exit;
		return $err;
	}
	
	@arr = $dbh->ListTables;
	foreach $i (0..$#arr){
		if ($arr[$i] eq $table_name) {
			$err = "<br>There's already a table named <b><i>$table_name</i></b>.  Please choose another name";
			&print_error($err) unless $no_exit;
			return $err;
		}
	}
	return $err;

}

sub short_date {
	my($time_in)=@_;
	$time_in = time unless $time_in;

	my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($time_in);
	
	$year += 1900;
	$mon++;
	return "$mon/$mday/$year";
}

sub drop_table_final {
	
	my($drop_table) = @_;
	my($sth);

	$sth = $dbh->Query("DROP TABLE $drop_table") or &print_error("Drop Table Failed!");
	return 1;
}

sub check_new_fields {
	
	my($field_count)=@_;
	my($todo, $i, $err, $new_fields);
	my($field_names)=",";

	foreach $i (0..$field_count) {
	   	if ($in{"new_name$i"} ne "") {
			$todo=1;
			$new_fields++;
			
			&print_error("Field Name ".$in{"new_name$i"}." is used more than once.  Please use unique names for the fields you want to add.") if $field_names =~ /",".$in{"new_name$i"}.","/;
			$field_names .= $in{"new_name$i"}.",";

			if (&field_exists($table, $in{"new_name$i"}) and ($in{'action'} ne "mod_fields_final")) {
				$err .= "Field <i>".$in{"new_name$i"}."</i> already exists (New field #$i)<br>";
			
			} else {
				if ($in{"type$i"}) {
					if ($in{"type$i"} == 2) {
						if ($in{"length$i"}) {
							$err .= "Please enter a number for the length of new field #$i (CHAR field)<br>" if $in{"length$i"} =~ /\D/;
						} else {
							$err .= "Please enter the length for new field #$i (CHAR field)<br>";
						}
					} else {
						$err.= "New field #$i: Invalid SQL Field Name:<i>".$in{"new_name$i"}."</i><br>$valid_names_text<br>" unless &valid_sql_name($in{"new_name$i"});
					}
				} else {
					$err .= "Please select the type for new field #$i<br>";
				}
			}
	   	}
	}
	
	&print_error("No new fields to create!") unless $todo; #nada to do
	&print_error($err) if $err; #print errors if any
	return 1;
}

sub SQLCreate {
	
	#returns a string with the field names, type, lenght in SQL format in a table
	#for example, FIELD_NANE1 CHAR(30) NOT NULL PRIMARY KEY, FIELD_NANE2 INT NOT NULL, etc...

	my($table_name)=@_;
	my($sql)="\n";
	my($sth);
	
	$sth = $dbh->ListFields($table_name);
	for (0..$sth->numfields-1) {
		if ($in{"delete$_"}) {
			#the field was chosen to be deleted

		} else {
			$sql .= &get_field_create_sql(
									$sth->name->[$_], 
									$sth->type->[$_], 
									$sth->length->[$_],
									$sth->is_pri_key->[$_],
									$sth->is_not_null->[$_]); 

			$sql .= ",";
			$field_name[$_] = $sth->name->[$_];
			$field_type[$_] = $sth->type->[$_];
			#these 2 arrays hold name & type of fields in the $table, respectively
		}
		
	}
	
	$sql = &remove_last_comma($sql);
	return $sql;
}

sub show_data {
	
	print "<br>Table data<br>\n";
	my $numRows = &print_sql_results(&SQLSelect($table));
	print "There are <b>$numRows</b> rows of data in this table.<br>";
	return 1;
}

sub get_separator {
		
	my($title, $filename) =@_;
	my $table_list;
	my $table_hidden;
	
	if ($title eq "Export To Text File") {
		$table_list  = "<tr>\n<td align=right>Please Select Table To Export:</td>\n";
		$table_list .= "<td>".&table_list."</td></tr>\n";		
		$in{'action'} = "$in{'action'}_final";
	} else {
		$table_hidden = "<INPUT TYPE = \"HIDDEN\" NAME = \"table\" VALUE=\"$table\">";
	}

	print &html($title);
	print "
			$form_method
			<b>Options:</b>
			<table border = 0>
			<tr>
				$table_list
				<td align=right>Field Separator:</td>
				<td><SELECT NAME=\"separator\">
						<OPTION VALUE=\"\">** Please Select **
			    		<OPTION VALUE=\"\|\">\Pipe Character: \|
						<OPTION VALUE=\"tab\">Tab Character
						<OPTION VALUE=\",\">Comma: ,
						<OPTION VALUE=\"other\">Other 
					</SELECT> 
					If Other, please specify: 
					<INPUT TYPE = \"TEXT\" NAME = \"other_separator\" SIZE=\"3\" MAXLENGTH=\"3\">
				</td>
			</tr>
			<tr>
				<td align=right>Field Names On First Row:</td>
				<td><SELECT NAME=\"column_names\">
						<OPTION VALUE=\"1\" SELECTED>Yes
			    		<OPTION VALUE=\"\">No
					</SELECT>
				</td>
			</tr>
			</table>
			<center><INPUT TYPE = \"submit\" NAME = \"submit\" value=\"$title\"></center>
			<INPUT TYPE = \"HIDDEN\" NAME = \"action\" VALUE=\"$in{'action'}\">
			$table_hidden
			<INPUT TYPE = \"HIDDEN\" NAME = \"step\" VALUE=\"2\">
			<INPUT TYPE = \"HIDDEN\" NAME = \"filename\" VALUE=\"$filename\">
			</form>";

	print &html_bot;
	exit;
	#Enclose CHARacter (Text) field values around:</td><td>
	#<SELECT NAME=\"text_delimiter\">
	#<OPTION VALUE=\"\">Nothing
	#<OPTION VALUE=\"quotes\">Quotes: \"
	#<OPTION VALUE=\"\'\">Single Quotes: \'
	#</SELECT></td></tr><tr><td align=right>

}
sub date_time {	
	
	my($time_in)=@_;1;
	$time_in = time if not $time_in;
	my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($time_in);
	
	$year += 1900;
	$mon++;
	$year =  substr($year,2,2);
	$mon  = "0$mon"	 if $mon<10;
	$mday = "0$mday" if $mday<10;
	$hour = "0$hour" if $hour<10;
	$min  = "0$min"  if $min<10;
	$sec  = "0$sec"  if $sec<10;
	return "$mon/$mday/$year $hour:$min:$sec";

}

sub typeSelect {
	my($type)=@_;
	return qq*<SELECT NAME="type#"><OPTION VALUE=""><OPTION VALUE="1">INT\n<OPTION VALUE="2" SELECTED>CHAR\n<OPTION VALUE="3">REAL</SELECT>* if $type==2; 
	return qq*<SELECT NAME="type#"><OPTION VALUE=""><OPTION VALUE="1" SELECTED>INT\n<OPTION VALUE="2">CHAR\n<OPTION VALUE="3">REAL</SELECT>* if $type==1; 
	return qq*<SELECT NAME="type#"><OPTION VALUE=""><OPTION VALUE="1">INT\n<OPTION VALUE="2">CHAR\n<OPTION VALUE="3" SELECTED>REAL</SELECT>* if $type==3; 
}	

sub isReal {
  	my($temp) = @_;
	my($lbound) = -9223372036854775808;
	my($ubound) =  9223372036854775808;

 	$temp =~ s/\.//; #remove the first dot
 	$temp = substr($temp, 1, length($temp)-1) if substr($temp, 0, 1) = "-"; #in case it is a minus number

 	if ($temp =~ /\D/) { 
 		return 0;
 
 	} else {
 		if (($temp >= $lbound) && ($temp <= $ubound)) {
 			return 1;
 		} else {
 			return 0;
 		}
 	}
}
 
sub isInt {
 	my($temp) = @_;
	my($lbound) = -2147483648;
	my($ubound) =  2147483648;

	$temp = substr($temp, 1, length($temp)-1) if substr($temp, 0, 1) = "-"; #in case it is a minus number
	if ($temp =~ /\D/) { 
		#$temp =~ s/\D/$rep/eg;
		#print "Bad://$temp//<br>";
 		return 0;
 	
	} else {
		if (($temp >= $lbound) and ($temp <= $ubound)) {
 			return 1;
 		} else {
 			return 0;
 		}
 	}
}

sub table_list {
	
	my($i, $list);
	my(@arr) = $dbh->ListTables;
	@arr = sort (@arr);
	return "<b>No Tables Found!</b>" unless $#arr;
	$list  = "<SELECT NAME=\"table\">\n";
	$list .= "<OPTION VALUE=\"\">** Please Select **";

    foreach $i (0..$#arr){
		$list .= "<OPTION VALUE=\"$arr[$i]\">$arr[$i]\n" unless $excluded_tables =~ /,$arr[$i],/;
	}
	$list .= "</SELECT>\n";
	return $list;
}

sub table_field_count {
	my($table_name) = @_;
	my($my_sth) = $dbh->ListFields($table_name);
	my($i) = $my_sth->numfields;
	return $i;
}

sub valid_sql_name {
	my($sql_name) = @_;

	if (length($sql_name) > 20) {
		return 0;
	} else {
		if ($sql_name =~ /^[a-zA-Z][_a-zA-Z0-9]*$/) { 
			for (0..$#ReservedWords) {
				if ("\L$ReservedWords[$_]\E" eq "\L$sql_name\E") {
				   return 0;
				}
			}
			return 1;
		} else {
			return 0;
		}
	}

	#A B C D E F G H I J K L M N O P Q R S T U V W X Y Z 
	#a b c d e f g h i j k l m n o p q r s t u v w x y z 
	#0 1 2 3 4 5 6 7 8 9 
	#_ (that's an "underbar" NOT a "dash") 
	#The maximum name length is set to 20 characters.

}

sub trim {
	#removes leading and trailing spaces
	my($val) = @_;
	$val =~ s/^\s*|\s+$//g;
	return $val;
}

sub sql_string {
	#prepares an sql string for an SQL statement
	#it escapes the \ character and the ' character inside a value
	#also, if the field value is longer than the length of the field
	#it truncates it down to the lenght
	my($temp, $i) = @_;
	
	#print "Inside sql_string: Value: $temp<br>";
	if (length($temp) > $field_length[$i]) {
	   $temp = substr($temp, 0, $field_length[$i]);
	}
	$temp =~ s/\'/$quote_rep/eg;
	$temp =~ s/\\/$back_slash_rep/eg;
	$temp = "\'$temp\'";
	#print "on exit: $temp<BR><BR>";
	return $temp;
}

sub numeric_type {
	#returns true if the type is 
	#one of the numeric types of mSQL (real, integer, money(ver2), etc.
	my($type) = @_;
	return 1 if $type == 1 or $type == 3;
	return 0;
}

sub char_type {
	#returns true if the type is 
	#one of the string types of mSQL (char, text, date, etc.)
	my($type) = @_;
	return 1 if $type == 2; # or $type == 3;
	return 0;
}

sub log {
	open (LOG, ">>/u/web/cyberj/datafiles/log.txt") or print "shit";
	print LOG $_[0];
	close LOG;
	return;
}

sub insert_from_array {
	
	local(*arr, $sql, $field_count) = @_;
	my($sth_insert, $i, $ins_sql) = (0, 0, '');
	
	foreach $i (0..$field_count) {
		if (not defined($arr[$i])) {
			#if not defined, then this is probably a NULL value
			if ($field_not_nulls[$i]) {
				#can't take nulls
				$arr[$i] = "\'\'" if &char_type($field_type[$i]);	
				$arr[$i] = "0" unless ($field_type[$i] == 2);	
			} else {
				#can take NULLS
				$arr[$i] = "NULL";	
			}

		} else {
			if ($arr[$i] ne "NULL") {
				if (&char_type($field_type[$i])) {
					$arr[$i] = &sql_string($arr[$i], $i); #SQL encode strings 

				} else {
					$arr[$i] = &trim($arr[$i]);
					$arr[$i] = 0 if $arr[$i] eq '';

					if ($field_type[$i] == 1) {
						$arr[$i] = '0' unless &isInt($arr[$i]);

					} elsif ($field_type[$i] == 3) {
						$arr[$i] = '0' unless &isReal($arr[$i]);
					}
				}
			}
		}
		$ins_sql .= "$arr[$i], ";
	}	

	$ins_sql = &remove_last_comma($ins_sql);
 	$sth_insert = $dbh->Query("$sql$ins_sql\)") or 
			&print_error("INSERT Statement Failed:<br><pre>$sql$ins_sql\)<br>".($Msql::db_errstr)."</pre>");
	return 1;
}

sub print_sql_results {
	
	# print results from an sql statement
	# $sql :Statement to submit to the mSQL engine
	
	my ($sql) = @_;
	my($field_info, @arr, $i, $recno, $numRows, $printIt);

	my $sth = $dbh->Query("$sql") or &sql_fail($sql);
		
	for (0..$sth->numfields-1) {
		my $field_name = $sth->name->[$_];
		$field_info .= "\t<td><b><center>$field_name</b></center></td>\n";
	}

	$numRows = $sth->numrows;
	print " <table border=1>
				<tr bgcolor=\"#c0e0a0\">
					<td>&nbsp;</td>
					$field_info
				</tr>
				<tr valign=top>\n";

	$recno = 0;
	$printIt = 1;
	while(@arr = $sth->FetchRow) {
		$recno ++;
		$printIt = (($recno <=500) or ($recno >= ($numRows - 5)) or ($numRows <= 600));
		#I do not print more than 500 records (HTML page gets too big)
		#If table contains > 500 records, I will print the first 500 and the last 4 records
		#If the table up to 600 records, i'll just show them all
		print "<tr valign=top>\n";
		if ($printIt) {
			print "<td>$recno</td>";
			foreach  $i (0..$#arr) {
				print "<td nowrap>$arr[$i]&nbsp;</td>\n";
			}
			print "</tr>\n";
		}
		if (($recno == 501) and ($numRows > 600)) {
			print "<td>...</td>";
			foreach  (0..$#arr) {
				print "<td nowrap>&nbsp;</td>\n";
			}
		}
	}
	
	print "</table><p>\n";
	return $numRows;
}
1;